<?php
/**
 * Core: The Database class
 *
 * @link        https://oxyprops.com
 *
 * @package     OxyProps
 * @subpackage  Core
 * @author      Cédric Bontems <cedric@thewebforge.dev>
 * @since       1.5.0
 * @copyright   Copyright (c) 2022, Cédric Bontems
 * @license     https://www.gnu.org/licenses/gpl-2.0.html  GPLv2 or later
 */

namespace OxyProps\Inc;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * OxyProps\Inc\Database.
 *
 * Manages interactions with the database.
 *
 * @since 1.5.0 Creation.
 * @author Cédric Bontems <cedric@thewebforge.dev>
 */
class Database {

	use Singleton;

	/**
	 * The name of the plugin option in the database.
	 *
	 * @since 1.5.0
	 * @var string
	 */

	/**
	 * The name of the plugin option in the database.
	 *
	 * @since 1.5.0 Creation.
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * @var string $option_name The name of the plugin option in the database.
	 */
	private string $option_name;

	/**
	 * Initialize Database class.
	 *
	 * Called by the constructor. It retreives and populates all the class properties.
	 *
	 * @since 1.5.0 Creation.
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * @return void
	 */
	private function register() {
		$this->option_name = 'oxyprops';
	}

	// * Getters and Setters.

	/**
	 * Retrieves the option value for the option name.
	 *
	 * If the option does not exist or does not have a value,
	 * then the default settings will be returned.
	 *
	 * @see https://developer.wordpress.org/reference/functions/get_option/
	 *
	 * @since 1.5.0 Creation.
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * @return array The current settings array stored in the database.
	 */
	public function get_option(): array {
		$defaults = Init::get_instance( 'defaults' );
		if ( method_exists( $defaults, 'get_oxyprops_default_settings' ) ) {
			return get_option( $this->option_name, array( 'settings' => $defaults->get_oxyprops_default_settings() ) );
		}
	}
}
